/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.graphics;


public final class FontMetrics {
	int ascent, descent, height, averageCharWidth;

public boolean equals (Object object) {
	if (object == this) return true;
	if (!(object instanceof FontMetrics)) return false;
	FontMetrics mt = (FontMetrics) object;
	return ascent == mt.ascent &&
		descent == mt.descent &&
		height == mt.height &&
		averageCharWidth == mt.averageCharWidth;
}

public int getAscent () {
	return ascent;
}

public int getAverageCharWidth () {
	return averageCharWidth;
}

public int getDescent () {
	return descent;
}

public int getHeight () {
	return height;
}

public int getLeading () {
	return 0;
}

public int hashCode () {
	return ascent ^ descent ^ height ^ averageCharWidth;
}

public static FontMetrics internal_new(int ascent, int descent, int height, int averageCharWidth) {
	FontMetrics mt = new FontMetrics();
	mt.ascent = ascent;
	mt.descent = descent;
	mt.height = height;
	mt.averageCharWidth = averageCharWidth;
	return mt;
}

}
